Attribute VB_Name = "createPyramid"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


'Visual Basic example  to create a regular pyramid on an active document

Dim app As ProDESKTOP          'Define variable used to hold the ProDESKTOP object
Dim part As PartDocument          'Define variable used to hold the PartDocument object

Dim numberOfSides As Integer                'Define variable used to hold the Number of sides of the polygon
Dim lengthOfSide As Double                  'Define variable used to hold the length of side of the polygon

Dim extrDistance As Double
Dim direction As Double
Dim taperAngle As Double
Dim materialstatus As Double
Dim extrusionName As String

Public Sub RegularPyramidExample()

Call SetDataForPyramid
Call CreatePyramid(numberOfSides, lengthOfSide, extrDistance, direction, taperAngle, materialstatus)

End Sub

Private Function SetDataForPyramid()

'Set the User input for the number of sides , the length of the side,extrusion distance,
'direction,Taper Angle,Material Status, extrusion name

'Set the User input for the number of sides and the length of the side.

Dim msgSide As String
Dim msgLength As String
Dim msgDist As String
Dim msgDirection As String
Dim msgTaperAngle As String
Dim msgMatStatus As String
Dim msgFeatName As String

msgSide = "Please enter the number of sides of the polygon"
msgLength = "Please enter the length of the side in meters"
msgDist = "Please enter the extrusion distance"
msgDirection = "Please enter the direction of extrusion"
msgDirection = msgDirection + "( 0 - Above , 1 - Below , 2 - Symmetric about Workplane )"
msgTaperAngle = "Please enter the taper angle of extrusion"
msgMatStatus = "Please enter the material status"
msgMatStatus = msgMatStatus + "( 1 - Unite , 2 - Subtract , 3 - Intersect Material)"
msgFeatName = "Please enter the feature name"

numberOfSides = InputBox(msgSide, "Number of sides")
lengthOfSide = InputBox(msgLength, "Length of side")
extrDistance = InputBox(msgDist, "Extrusion Distance")
direction = InputBox(msgDirection, "Direction of Extrusion")
taperAngle = InputBox(msgTaperAngle, "Taper Angle")
materialstatus = InputBox(msgMatStatus, "Material Status")
extrusionName = InputBox(msgFeatName, "Feature Name")

End Function

Private Sub CreatePyramid(numberOfSides, lengthOfSide, extrDistance, direction, taperAngle, materialstatus)

' Subroutine to create a Regular pyramid with a given the length ,number of sides,
' height and taper angle in an active part of a ProDESKTOP Session

' Creates the polygon with the given length and the number of sides on the Active sketch.
' Origin for the polygon is (0,0)
' Draws the first line by using the length value and assuming angle to be zero.
' Subsequent lines are drawn using cosine and sine of the exterior angle for the
' polygon.

'Creates a pyramid by extruding the created profile by given distance,taper angle.

Const pause As Boolean = False

'Connect to the ProDESKTOP Application object.
Set app = CreateObject("ProDESKTOP.Application")

If app Is Nothing Then        'Exit if no ProDESKTOP Application Object is created.
    MsgBox ("Could not create the ProDESKTOP Application Object")
    Exit Sub
End If

app.SetVisible (True)                'Make the ProDESKTOP Application Visible.

'Exit if no Part document is active
On Error GoTo NoDocErr
Set part = app.GetActiveDoc()        'Get the active document
On Error GoTo 0

'Take the helm
Dim api As helm
Set api = app.TakeHelm

If part Is Nothing Then                     'Exit if no Part document is active
    MsgBox ("Could not get the Part Object")
    Exit Sub
End If

'Create an SetClass
Dim setCls As ObjectSetClass
Set setCls = app.GetClass("ObjectSet")

'Create an Object Set
Dim objSet1 As ObjectSet
Set objSet1 = setCls.CreateAObjectSet

Rem Creating a polygon

'Initialize the starting vectors
startx = 0#
starty = 0#
startz = 0#

'Create a VectorClass
Dim vecCls As VectorClass
Set vecCls = app.GetClass("Vector")

'Create the first vector
Dim firstVector  As zVector
Set firstVector = vecCls.CreateVector(startx, starty, startz)

'Set the initial value for the Angle
Let pAngle = 0

'Set the initial values of x1,y1,z1
Let x1 = startx
Let y1 = starty
Let z1 = startz

For i = 1 To (numberOfSides - 1)

    'Create a vector using the x1,y1,z1 values
    Dim vector1  As zVector
    Set vector1 = vecCls.CreateVector(x1, y1, z1)
    
    'Set the x2 coordinate  using the Cosine of the Angle and the Length of the side
    'Set the y2 coordinate  using the Sine of the Angle and the Length of the side
    
    X2 = x1 + lengthOfSide * Cos(pAngle)
    Y2 = y1 + lengthOfSide * Sin(pAngle)
    z2 = 0#
    
    'Create a vector using the x2,y2,z2 values
    Dim vector2  As zVector
    Set vector2 = vecCls.CreateVector(X2, Y2, z2)
    
    'Use the Function CreateLine(startPt As ZVector, endPt As ZVector)
    'to create a line between the two given vectors
    
    Dim line As aLine
    Set line = CreateLine(vector1, vector2)
    
    'Add the line to the object set
    objSet1.AddMember line
    
       
    'Set the angle using the following formula
    pAngle = pAngle + 2 * 3.1415 / numberOfSides
    
    'Set the x1,y1,z1 values for the next iteration
    
    Let x1 = X2
    Let y1 = Y2
    Let z1 = z2

Next i                          'End Loop

'Create a Line using the CreateLine function between the last vector
'and the first vector in order to close the polygon

Dim lastLine As aLine
Set lastLine = CreateLine(vector2, firstVector)

'Add the last line to the object set
objSet1.AddMember lastLine

'Get the Active Workplane
Dim wp As aWorkplane
Set wp = part.GetActiveWorkplane

'Use the AutoConstrain API to constrain the line set.
wp.AutoConstrain objSet1

'Create an ExtrusionClass
Dim extrusionCls As ExtrusionClass
Set extrusionCls = app.GetClass("Extrusion")

'Creating a Regular Pyramid by extruding the given profile

Dim extrusion1 As aExtrusion
Set extrusion1 = extrusionCls.CreateExtrusion(part.GetDesign, part.GetActiveSketch, extrDistance, direction, taperAngle, 0, materialstatus, 0)
extrusion1.SetName extrusionName
part.UpdateDesign

api.CommitCalls "CreatePyramid", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub
        
End Sub

Private Function CreateLine(startPt As zVector, endPt As zVector)

'Get the Active Skecth and its parent workplane
Dim Sketch As aSketch
Set Sketch = part.GetActiveSketch
Dim plane As aWorkplane
Set plane = Sketch.GetParent("Workplane")

Dim startPoint As zVector
Dim endPoint As zVector

Dim localStart As zVector
Dim localEnd As zVector

'Get the local start and end vectors for the active workplane
Set localStart = plane.Get3DVector(startPt)
Set localEnd = plane.Get3DVector(endPt)

'Create a BasicStraightClass
Dim basicStrCls As BasicStraightClass
Set basicStrCls = app.GetClass("BasicStraight")

'Create a zCurve
Dim curve1 As zCurve
Set curve1 = basicStrCls.CreateBasicStraightTwoPoints(localStart, localEnd)

'Create a line by passing the zCurve
Dim line1 As aLine
Set line1 = Sketch.CreateLine(curve1)

Set CreateLine = line1

End Function


